/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.samples.shell;

import com.jniwrapper.samples.shell.Category;
import com.jniwrapper.samples.shell.XMLDOMHelper;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class DemoModelHelper {
    private XMLDOMHelper _xmlHelper;
    private Document _xmlDocument;
    private Node _homeNode;
    private static DemoModelHelper _demoModelHelper = null;

    private DemoModelHelper(InputStream xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException("xmlFile parameter is null.");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this._xmlDocument = builder.parse(xmlFile);
            this._xmlHelper = new XMLDOMHelper();
            this._homeNode = this._xmlDocument.getFirstChild();
            if (this._homeNode == null) {
                throw new IllegalArgumentException("Error parsing XML file.");
            }
        }
        catch (SAXException sxe) {
            sxe.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getWindowCaption() {
        return this._xmlHelper.getValueByName(this._homeNode, "WindowCaption");
    }

    public String getIntroTitle() {
        return this._xmlHelper.getValueByName(this._homeNode, "IntroTitle");
    }

    public String getIntro() {
        return this._xmlHelper.getValueByName(this._homeNode, "Intro");
    }

    public boolean isShowLegend() {
        return "true".equalsIgnoreCase(this._xmlHelper.getElementByName(this._homeNode, "Intro").getAttribute("showLegend"));
    }

    public Category getRoot() {
        Element catagories = this._xmlHelper.getElementByName(this._homeNode, "Categories");
        if (!this._xmlHelper.isDefienedInNode(catagories, "Category")) {
            return null;
        }
        return new Category(this._xmlHelper.getElementByName(catagories, "Category"));
    }

    public static void init(InputStream xmlFile) {
        _demoModelHelper = new DemoModelHelper(xmlFile);
    }

    public static DemoModelHelper getInstance() {
        if (_demoModelHelper == null) {
            throw new RuntimeException("DemoModelHelper is not initialized. Call init() method first.");
        }
        return _demoModelHelper;
    }
}

