/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.samples.shell;

import com.jniwrapper.samples.shell.AboutPanel;
import com.jniwrapper.samples.shell.CategoryPanel;
import com.jniwrapper.samples.shell.DemoModelHelper;
import com.jniwrapper.samples.shell.DemoTreeModel;
import com.jniwrapper.samples.shell.HeaderPanel;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.samples.shell.components.TreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicDemoShell
extends JFrame {
    private static String PROPERTY_ACTIVE_SAMPLE = "demo.sample";
    private static final Logger LOG = LoggerFactory.getLogger(BasicDemoShell.class);
    private DemoModelHelper _DemoModelHelper;
    private JTree _menuTree;
    private Class _sourcePanel;

    public BasicDemoShell(InputStream xmlFile, Class sourcePanel) {
        DemoModelHelper.init(xmlFile);
        this._sourcePanel = sourcePanel;
        this._DemoModelHelper = DemoModelHelper.getInstance();
        this.setTitle(this._DemoModelHelper.getWindowCaption());
        this.setDefaultCloseOperation(3);
        Container contentPane = this.getContentPane();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        final HeaderPanel headerPanel = new HeaderPanel();
        Dimension headerSize = new Dimension(390, 30);
        headerPanel.setPreferredSize(headerSize);
        headerPanel.setMinimumSize(headerSize);
        headerPanel.setVisible(false);
        contentPanel.add((Component)headerPanel, "North");
        final JPanel sampleContainer = new JPanel();
        sampleContainer.setBorder(null);
        final CardLayout cardLayout = new CardLayout();
        sampleContainer.setLayout(cardLayout);
        sampleContainer.add((Component)new JPanel(), "empty");
        contentPanel.add((Component)sampleContainer, "Center");
        this._menuTree = new JTree();
        this._menuTree.setVisible(false);
        this._menuTree.setEditable(false);
        BasicTreeUI basicTreeUI = (BasicTreeUI)this._menuTree.getUI();
        basicTreeUI.setCollapsedIcon(new ImageIcon(BasicDemoShell.class.getResource("res/Closed.gif")));
        basicTreeUI.setExpandedIcon(new ImageIcon(BasicDemoShell.class.getResource("res/Opened.gif")));
        this._menuTree.setCellRenderer(new TreeCellRenderer());
        this._menuTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getPath();
                DefaultMutableTreeNode pathComponent = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
                BasicDemoShell.this.deactivateSample(sampleContainer);
                BasicDemoShell.this.showAndActivateSample(pathComponent, cardLayout, sampleContainer, headerPanel);
            }
        });
        headerPanel.getSampleButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = BasicDemoShell.this._menuTree.getSelectionPath();
                DefaultMutableTreeNode pathComponent = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
                BasicDemoShell.this.deactivateSample(sampleContainer);
                BasicDemoShell.this.showAndActivateSample(pathComponent, cardLayout, sampleContainer, headerPanel);
            }
        });
        headerPanel.getNoteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = BasicDemoShell.this._menuTree.getSelectionPath();
                DefaultMutableTreeNode pathComponent = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
                BasicDemoShell.this.deactivateSample(sampleContainer);
                BasicDemoShell.this.showAndActivateSample(pathComponent, cardLayout, sampleContainer, headerPanel);
            }
        });
        JScrollPane menuScroolPane = new JScrollPane(this._menuTree);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(null);
        content.add((Component)menuScroolPane, "West");
        content.add((Component)contentPanel, "Center");
        contentPane.add(content);
        this.setupTree(menuScroolPane);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String activeSample = System.getProperty(PROPERTY_ACTIVE_SAMPLE);
                LOG.info(PROPERTY_ACTIVE_SAMPLE + "=" + activeSample);
                if (activeSample != null) {
                    TreePath match = BasicDemoShell.this._menuTree.getNextMatch(activeSample, 0, Position.Bias.Forward);
                    if (match != null) {
                        BasicDemoShell.this._menuTree.setSelectionPath(match);
                    } else {
                        LOG.warn("Could not find the specified sample: " + activeSample);
                    }
                }
            }
        });
    }

    JTree getMenuTree() {
        return this._menuTree;
    }

    private void setupTree(JScrollPane menuScroolPane) {
        this._menuTree.setModel(new DemoTreeModel(this, this._sourcePanel));
        for (int i = 0; i < this._menuTree.getRowCount(); ++i) {
            this._menuTree.expandRow(i);
        }
        this._menuTree.setSelectionRow(0);
        this._menuTree.setVisible(true);
        this._menuTree.putClientProperty("JTree.lineStyle", "None");
        menuScroolPane.setMinimumSize(menuScroolPane.getSize());
    }

    private void deactivateSample(JPanel container) {
        Component component = null;
        int componentCount = container.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component visibleComponent = container.getComponent(i);
            if (!visibleComponent.isVisible()) continue;
            component = visibleComponent;
            break;
        }
        if (component instanceof LazyPanel) {
            ((LazyPanel)component).deactivate();
        }
    }

    void showAndActivateSample(DefaultMutableTreeNode pathComponent, CardLayout cardLayout, JPanel container, HeaderPanel headerPanel) {
        Object userObject = pathComponent.getUserObject();
        if (pathComponent instanceof DemoTreeModel.DemoNode && ((DemoTreeModel.DemoNode)pathComponent).getShowSources() && !headerPanel.getSampleChecked()) {
            userObject = ((DemoTreeModel.DemoNode)pathComponent).getSourcesPanel();
        }
        if (userObject instanceof AboutPanel) {
            headerPanel.setTitle(this._DemoModelHelper.getIntroTitle());
        } else {
            headerPanel.setTitle(pathComponent.toString());
        }
        if (userObject instanceof JPanel) {
            JPanel sample = (JPanel)userObject;
            String name = String.valueOf(sample.hashCode());
            if (!this.containerContains(container, sample)) {
                container.add((Component)sample, name);
            }
            cardLayout.show(container, name);
            if (userObject instanceof AboutPanel) {
                headerPanel.setVisible(true);
                headerPanel.setButtonsVisible(false);
            } else if (userObject instanceof LazyPanel) {
                headerPanel.setVisible(true);
                if (pathComponent instanceof DemoTreeModel.DemoNode) {
                    if (((DemoTreeModel.DemoNode)pathComponent).getShowSources()) {
                        headerPanel.setButtonsVisible(true);
                    } else {
                        headerPanel.setButtonsVisible(false);
                    }
                } else {
                    headerPanel.setButtonsVisible(false);
                }
                try {
                    ((LazyPanel)userObject).activate();
                }
                catch (Exception ex) {
                    LOG.error("", (Throwable)ex);
                }
            } else if (userObject instanceof CategoryPanel) {
                headerPanel.setVisible(true);
                headerPanel.setButtonsVisible(false);
            } else {
                headerPanel.setVisible(false);
                headerPanel.setButtonsVisible(false);
            }
        } else {
            headerPanel.setVisible(true);
            headerPanel.setButtonsVisible(false);
            cardLayout.show(container, "empty");
        }
    }

    private boolean containerContains(JPanel container, JPanel sample) {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (!component.equals(sample)) continue;
            return true;
        }
        return false;
    }
}

