/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.samples.shell;

import com.jniwrapper.samples.shell.DemoModelHelper;
import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LineBevel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class AboutPanel
extends JPanel {
    private Component _htmlDisplayComponent;
    private DemoModelHelper _demoModelHelper = DemoModelHelper.getInstance();

    public AboutPanel() {
        String currentYearInteger = this.getCurrentYear();
        String ABOUT_HTML = MessageFormat.format(this._demoModelHelper.getIntro(), currentYearInteger);
        this.setBorder(null);
        this.setLayout(new GridBagLayout());
        HTMLText htmlText = new HTMLText(ABOUT_HTML, true);
        htmlText.setAntialiasedText(false);
        this._htmlDisplayComponent = htmlText;
        this.add(this._htmlDisplayComponent, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this._demoModelHelper.isShowLegend()) {
            JPanel legend = new JPanel(new GridBagLayout());
            LineBevel bevel = new LineBevel();
            HTMLText lblLegend = new HTMLText("<b><nobr>Legend:</nobr></b>");
            JLabel lblUnmodified = new JLabel(" - Unmodified", new ImageIcon(AboutPanel.class.getResource("res/Leaf.gif")), 2);
            JLabel lblNew = new JLabel(" - New", new ImageIcon(AboutPanel.class.getResource("res/LeafNew.gif")), 2);
            JLabel lblUpdated = new JLabel(" - Updated", new ImageIcon(AboutPanel.class.getResource("res/LeafUpdate.gif")), 2);
            legend.add((Component)lblUnmodified, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 5), 0, 0));
            legend.add((Component)lblNew, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 5), 0, 0));
            legend.add((Component)lblUpdated, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 5), 0, 0));
            legend.add((Component)new JPanel(), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)lblLegend, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.add((Component)bevel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 7, 0, 5), 0, 0));
            this.add((Component)legend, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 10, 10), 0, 0));
        }
    }

    private String getCurrentYear() {
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int year = calendar.get(1);
        return Integer.toString(year);
    }

    @Override
    public String toString() {
        return this._demoModelHelper.getRoot().getName();
    }
}

