/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.JNIWrapperException;
import com.jniwrapper.Library;
import com.jniwrapper.LibraryLoader;
import com.jniwrapper.LibraryNotFoundException;
import com.jniwrapper.LibraryVersionMismatchException;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.af;
import com.jniwrapper.l;
import com.jniwrapper.s;
import com.jniwrapper.util.StreamUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLibraryLoader
implements LibraryLoader {
    private static final Logger f = LoggerFactory.getLogger((Class)(g == null ? (g = DefaultLibraryLoader.a("com.jniwrapper.DefaultLibraryLoader")) : g));
    private static DefaultLibraryLoader i = null;
    private s a;
    private static String c = null;
    private String d;
    private static int h = 0;
    public static final String JAVA_LIBRARY_PATH = "java.library.path";
    public static Class g;
    public static Class e;
    public static Class b;

    private DefaultLibraryLoader() {
        this((g == null ? (g = DefaultLibraryLoader.a("com.jniwrapper.DefaultLibraryLoader")) : g).getClassLoader(), System.getProperty(JAVA_LIBRARY_PATH), Library.NATIVE_CODE);
    }

    public DefaultLibraryLoader(ClassLoader classLoader, String string, String string2) {
        this.a = new af(classLoader, string, string2);
        this.b();
    }

    private void b() {
        try {
            Object object;
            f.debug("DefaultLibraryLoader.generateTmpFolderName");
            String string = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
            f.debug("classContainer = " + string);
            String string2 = this.b(string);
            f.debug("bundleVersion = " + string2);
            String string3 = this.c(string);
            f.debug("jarName = " + string3);
            String string4 = System.getProperty("JNIWrapper.extract.path");
            String string5 = string4 != null ? string4 : this.a();
            f.debug("systemTempFolder = " + string5);
            boolean bl2 = string5.endsWith(File.separator);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string5);
            if (!bl2) {
                stringBuffer.append(File.separator);
            }
            if (string3.length() != 0) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append("JNIWrapper");
            }
            stringBuffer.append(".Build.");
            stringBuffer.append(string2);
            try {
                Class<?> clazz = Class.forName("java.util.UUID");
                Method method = clazz.getMethod("randomUUID", new Class[0]);
                object = method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                int n2 = this.getClass().getClassLoader().hashCode();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(n2);
                stringBuffer2.append(System.currentTimeMillis());
                object = stringBuffer2.toString();
            }
            stringBuffer.append(object);
            if (bl2) {
                stringBuffer.append(File.separator);
            }
            this.d = stringBuffer.toString();
            f.debug("DefaultLibraryLoader.generateTmpFolderName: " + this.d);
        }
        catch (Exception exception) {
            f.debug("Unable to alter tmp folder. Trying to use the system one", (Throwable)exception);
            try {
                this.d = this.a();
            }
            catch (IOException iOException) {
                f.debug("Unable to alter tmp folder.", (Throwable)iOException);
            }
        }
    }

    private String c(String string) {
        f.debug("DefaultLibraryLoader.getJarName from the container: " + string);
        int n2 = string.lastIndexOf("/") + 1;
        String string2 = string.substring(n2);
        int n3 = string2.lastIndexOf(".");
        if (n3 == -1) {
            n3 = string2.length();
        }
        string2 = string2.substring(0, n3);
        return string2;
    }

    private String b(String string) {
        String string2 = "Unknown";
        if (!string.endsWith("/")) {
            try {
                URL uRL = new URL("jar:" + string + "!/META-INF/MANIFEST.MF");
                Manifest manifest = new Manifest(uRL.openStream());
                Attributes attributes = manifest.getMainAttributes();
                string2 = attributes.getValue("Bundle-Version");
                if (string2 == null) {
                    string2 = attributes.getValue("Version");
                }
            }
            catch (IOException iOException) {
                f.debug("Unable to retrieve version", (Throwable)iOException);
                string2 = "Unknown";
            }
        }
        if (string2 == null) {
            string2 = "Unknown";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a() throws IOException {
        String string;
        try {
            string = PlatformContext.isMacNewerThanTigerButOlderThanMavericks() ? "/private/tmp" : System.getProperty("java.io.tmpdir");
        }
        catch (Exception exception) {
            File file = File.createTempFile("~tmp", "");
            try {
                string = file.getParent();
            }
            finally {
                file.delete();
            }
        }
        return string;
    }

    public static DefaultLibraryLoader getInstance() {
        if (i == null) {
            i = new DefaultLibraryLoader();
        }
        return i;
    }

    public void addPath(File file) {
        this.a.b(file);
    }

    public void prependPath(File file) {
        this.a.a(file);
    }

    public void addPath(List list) {
        this.a.a(list);
    }

    public void addPath(String string) {
        this.a.b(string);
    }

    public File findLibrary(String string) {
        Object object;
        boolean bl2;
        String string2 = string;
        boolean bl3 = bl2 = string2.indexOf(Library.NATIVE_CODE) != -1;
        if (!new File(string).isAbsolute()) {
            string2 = DefaultLibraryLoader.mapLibraryName(string);
            if (bl2 && h >= 7 && PlatformContext.isMacOS()) {
                string2 = string2.replaceFirst(DefaultLibraryLoader.getLibraryExtension(), ".jnilib");
            }
        }
        f.debug("Finding library " + string2);
        Object object2 = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            f.debug("Class loader of '" + this.getClass() + "' class is null; trying to get context class loader...");
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                f.debug("Context class loader of current thread: " + Thread.currentThread() + " is null; using system class loader...");
                classLoader = ClassLoader.getSystemClassLoader();
            }
        }
        if (classLoader == null) {
            f.error("No available class loaders were found");
            throw new RuntimeException("Could not get any class loader");
        }
        try {
            object = classLoader.getResources(string2);
            while (object.hasMoreElements() && object2 == null) {
                URL uRL = object.nextElement();
                f.debug("Finding " + string2 + " library in JAR: " + uRL);
                if (uRL != null && uRL.getProtocol().startsWith("bundleresource")) {
                    uRL = this.a(uRL);
                    f.debug("Converting OSGi bundle URL to usual URL: " + uRL);
                }
                if (uRL != null && (uRL.getProtocol().startsWith("jar") || uRL.getProtocol().startsWith("bundle"))) {
                    f.debug("Looking for library in JAR or bundle" + uRL);
                    object2 = this.a(uRL, string2);
                }
                if (object2 != null && ((File)object2).exists() || uRL == null) continue;
                f.debug("Finding library in class path...");
                object2 = this.b(uRL);
                if (object2 == null || !bl2 || l.a((File)object2)) continue;
                object2 = l.a();
            }
        }
        catch (IOException iOException) {
            f.debug("Failed to scan jars for library", (Throwable)iOException);
        }
        if (object2 == null || !((File)object2).exists()) {
            f.debug("Finding library in system library path...");
            object2 = this.a.a(string2);
        }
        if ((object2 == null || !((File)object2).exists()) && PlatformContext.isMacOS()) {
            f.debug("Finding library in system library path on Mac OS X...");
            string2 = !string.endsWith(".dylib") && !string.endsWith(".jnilib") ? string + ".dylib" : string;
            object = this.a.a(string2);
            if (object != null) {
                object2 = object;
            }
            if (object2 == null || !((File)object2).exists()) {
                int n2 = string2.lastIndexOf("/");
                if (n2 > 0) {
                    String string3 = string2.substring(0, n2);
                    string2 = string3 + "/lib" + string2.substring(n2 + 1);
                } else {
                    string2 = "lib" + string2;
                }
                object = this.a.a(string2);
                if (object != null) {
                    object2 = object;
                }
            }
        }
        return object2;
    }

    private URL a(URL uRL) {
        try {
            Class<?> clazz = Class.forName("org.eclipse.core.runtime.FileLocator");
            Method method = clazz.getMethod("resolve", b == null ? (b = DefaultLibraryLoader.a("java.net.URL")) : b);
            return (URL)method.invoke(null, uRL);
        }
        catch (Exception exception) {
            f.debug("Cannot resolve OSGi Bundle URL with org.eclipse.core.runtime.FileLocator.");
            try {
                Class<?> clazz = Class.forName("org.eclipse.core.runtime.Platform");
                Method method = clazz.getMethod("resolve", b == null ? (b = DefaultLibraryLoader.a("java.net.URL")) : b);
                return (URL)method.invoke(null, uRL);
            }
            catch (Exception exception2) {
                f.debug("Cannot resolve OSGi Bundle URL with org.eclipse.core.runtime.Platform.");
                return null;
            }
        }
    }

    public static String urlToPath(URL uRL) {
        String string = uRL.getFile();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "%", false);
        int n2 = stringTokenizer.countTokens();
        if (n2 > 0) {
            String string2 = stringTokenizer.nextToken();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = string3.substring(0, 2);
                int n3 = Integer.parseInt(string4, 16);
                stringBuffer.append((char)n3);
                stringBuffer.append(string3.substring(2));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public void loadLibrary(String string) {
        File file = this.findLibrary(string);
        if (file == null) {
            throw new LibraryNotFoundException("Cannot find library: " + string);
        }
        if (!file.exists()) {
            throw new LibraryVersionMismatchException("Version of the library " + string + "found is not compatible with the current JNIWrapper version");
        }
        String string2 = file.getAbsolutePath();
        f.debug("Loading library from " + string2);
        System.load(string2);
    }

    public static String mapLibraryName(String string) {
        if (string.endsWith(DefaultLibraryLoader.getLibraryExtension())) {
            return string;
        }
        if (string.indexOf(".") != -1) {
            return string;
        }
        return System.mapLibraryName(string);
    }

    public static String getLibraryExtension() {
        if (c == null) {
            String string = "FooLibraryName";
            String string2 = System.mapLibraryName("FooLibraryName");
            int n2 = string2.indexOf("FooLibraryName");
            c = n2 == -1 ? "" : string2.substring(n2 + "FooLibraryName".length());
        }
        return c;
    }

    private File b(URL uRL) {
        String string = DefaultLibraryLoader.urlToPath(uRL);
        File file = new File(string);
        return file.exists() && file.isFile() ? file : null;
    }

    private File c() {
        File file = new File(this.d);
        if (!file.exists()) {
            boolean bl2 = file.mkdir();
            if (bl2) {
                f.debug("DefaultLibraryLoader.getTempFolder(), new directory was properly created: " + this.d);
                file.deleteOnExit();
            } else {
                f.debug("DefaultLibraryLoader.getTempFolder(), could not create directory: " + this.d);
                try {
                    this.d = this.a();
                    f.debug("DefaultLibraryLoader.getTempFolder(), using system temp folder instead: " + this.d);
                    file = new File(this.d);
                }
                catch (IOException iOException) {
                    f.error("DefaultLibraryLoader.getTempFolder(), Failed to get system temp folder", (Throwable)iOException);
                    throw new RuntimeException(iOException);
                }
            }
        } else {
            f.debug("DefaultLibraryLoader.getTempFolder(), such directory already exists: " + this.d);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File a(URL uRL, String string) {
        File file = null;
        try {
            File file2 = this.c();
            f.debug("DefaultLibraryLoader.findLibraryInJars. Loading resources to: " + file2);
            file = new File(file2, string);
            if (file.exists()) {
                return file;
            }
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            InputStream inputStream = uRL.openStream();
            try {
                StreamUtils.copy(inputStream, fileOutputStream, 1024);
            }
            finally {
                inputStream.close();
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (Exception exception) {
            f.error("Failed to extract JNIWrapper library to the " + this.d + " folder.", (Throwable)exception);
            JNIWrapperException.throwException(exception);
        }
        if (string.indexOf(Library.NATIVE_CODE) != -1 && !l.a(file)) {
            if (!file.delete()) {
                file.deleteOnExit();
            }
            file = l.a();
        }
        return file;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        String string = System.getProperty("java.runtime.version");
        if (string != null) {
            try {
                h = Integer.parseInt(string.substring(2, 3));
                f.debug("JAVA_VERSION = " + h);
                if (h >= 7 && PlatformContext.isMacOS()) {
                    String string2 = System.getProperty(JAVA_LIBRARY_PATH);
                    System.setProperty(JAVA_LIBRARY_PATH, ".:" + string2);
                }
            }
            catch (Exception exception) {
                f.debug("Failed to get Java version", (Throwable)exception);
            }
        } else {
            f.debug("Could not get Java version property");
        }
    }
}

